<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up(): void {
        Schema::create('referrals', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained('companies');
            $table->string('referrer_id');
            $table->string('referee_email');
            $table->string('referee_name')->nullable();
            $table->enum('status', ['PENDING', 'ACTIVE', 'CONVERTED', 'EXPIRED'])->default('PENDING');
            $table->string('code')->unique();
            $table->decimal('commission', 10, 2)->default(0);
            $table->dateTime('converted_at')->nullable();
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('referrals'); }
};
