<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up(): void {
        Schema::create('performance_metrics', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained('companies');
            $table->string('url');
            $table->decimal('lcp', 8, 2);
            $table->decimal('fid', 8, 2);
            $table->decimal('cls', 8, 2);
            $table->decimal('fcp', 8, 2);
            $table->decimal('ttfb', 8, 2);
            $table->integer('score');
            $table->string('region')->nullable();
            $table->string('device')->default('desktop');
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('performance_metrics'); }
};
