<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up(): void {
        Schema::create('roi_metrics', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained('companies');
            $table->string('campaign_id')->nullable();
            $table->string('name');
            $table->decimal('investment', 10, 2);
            $table->decimal('revenue', 10, 2);
            $table->decimal('roi', 10, 2);
            $table->string('period');
            $table->dateTime('start_date');
            $table->dateTime('end_date');
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('roi_metrics'); }
};
