<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up(): void {
        Schema::create('value_reports', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained('companies');
            $table->string('title');
            $table->json('metrics')->nullable();
            $table->string('period');
            $table->dateTime('generated_at');
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('value_reports'); }
};
