<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up(): void {
        Schema::create('sentiment_analysis', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained('companies');
            $table->enum('platform', ['LINKEDIN', 'TWITTER', 'FACEBOOK', 'INSTAGRAM', 'TIKTOK']);
            $table->text('content');
            $table->enum('sentiment', ['POSITIVE', 'NEUTRAL', 'NEGATIVE']);
            $table->decimal('score', 3, 2);
            $table->json('keywords')->nullable();
            $table->integer('mentions')->default(1);
            $table->json('engagement')->nullable();
            $table->dateTime('analyzed_at');
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('sentiment_analysis'); }
};
