<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up(): void {
        Schema::create('video_meetings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained('companies');
            $table->string('title');
            $table->string('platform');
            $table->string('meeting_url');
            $table->dateTime('start_time');
            $table->dateTime('end_time')->nullable();
            $table->json('participants')->nullable();
            $table->string('recording_url')->nullable();
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('video_meetings'); }
};
