<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up(): void {
        Schema::create('integrations', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('description');
            $table->string('category');
            $table->string('provider');
            $table->string('logo')->nullable();
            $table->decimal('rating', 3, 1)->default(0);
            $table->integer('installs')->default(0);
            $table->string('pricing')->default('Free');
            $table->json('features')->nullable();
            $table->string('status')->default('AVAILABLE');
            $table->boolean('is_installed')->default(false);
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('integrations'); }
};
