<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up(): void {
        Schema::create('resource_templates', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('category');
            $table->text('content')->nullable();
            $table->integer('downloads')->default(0);
            $table->string('file_url')->nullable();
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('resource_templates'); }
};
