<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up(): void {
        Schema::create('videos', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('filename');
            $table->string('original_url');
            $table->string('optimized_url')->nullable();
            $table->string('thumbnail_url')->nullable();
            $table->integer('size');
            $table->integer('duration')->nullable();
            $table->string('format');
            $table->enum('status', ['UPLOADING', 'PROCESSING', 'OPTIMIZED', 'FAILED'])->default('UPLOADING');
            $table->string('platform')->nullable();
            $table->foreignId('user_id')->constrained('users');
            $table->foreignId('company_id')->constrained('companies');
            $table->json('metadata')->nullable();
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('videos'); }
};
