<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up(): void {
        Schema::create('team_messages', function (Blueprint $table) {
            $table->id();
            $table->text('content');
            $table->string('type')->default('text');
            $table->foreignId('team_room_id')->constrained('team_rooms');
            $table->foreignId('user_id')->constrained('users');
            $table->string('file_url')->nullable();
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('team_messages'); }
};
