<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up(): void {
        Schema::create('task_items', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->text('description')->nullable();
            $table->enum('status', ['TODO', 'IN_PROGRESS', 'DONE'])->default('TODO');
            $table->string('priority')->default('medium');
            $table->string('assignee_id')->nullable();
            $table->foreignId('task_board_id')->constrained('task_boards');
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('task_items'); }
};
