<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up(): void {
        Schema::create('sla_records', function (Blueprint $table) {
            $table->id();
            $table->foreignId('ticket_id')->unique()->constrained('tickets');
            $table->integer('response_time')->nullable();
            $table->integer('resolution_time')->nullable();
            $table->boolean('breached_response')->default(false);
            $table->boolean('breached_resolution')->default(false);
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('sla_records'); }
};
