<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up(): void {
        Schema::create('security_sessions', function (Blueprint $table) {
            $table->id();
            $table->string('user_id');
            $table->string('ip_address');
            $table->string('user_agent');
            $table->boolean('is_active')->default(true);
            $table->dateTime('expires_at');
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('security_sessions'); }
};
