<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up(): void {
        Schema::create('api_keys', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('key')->unique();
            $table->foreignId('company_id')->constrained('companies');
            $table->boolean('is_active')->default(true);
            $table->dateTime('last_used')->nullable();
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('api_keys'); }
};
