<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up(): void {
        Schema::create('update_logs', function (Blueprint $table) {
            $table->id();
            $table->string('version');
            $table->text('description');
            $table->enum('status', ['PENDING', 'IN_PROGRESS', 'COMPLETED', 'FAILED'])->default('PENDING');
            $table->string('deployed_by');
            $table->foreignId('company_id')->constrained('companies');
            $table->dateTime('deployed_at')->nullable();
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('update_logs'); }
};
