<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up(): void {
        Schema::create('feature_flags', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('key')->unique();
            $table->text('description');
            $table->boolean('enabled')->default(false);
            $table->string('environment')->default('production');
            $table->foreignId('company_id')->constrained('companies');
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('feature_flags'); }
};
