<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up(): void {
        Schema::create('predictive_reports', function (Blueprint $table) {
            $table->id();
            $table->enum('type', ['REVENUE_FORECAST', 'CHURN_PREDICTION', 'CONVERSION_PROBABILITY']);
            $table->json('data')->nullable();
            $table->decimal('accuracy', 5, 2)->nullable();
            $table->foreignId('company_id')->constrained('companies');
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('predictive_reports'); }
};
