<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up(): void {
        Schema::create('communication_logs', function (Blueprint $table) {
            $table->id();
            $table->enum('type', ['CALL', 'SMS']);
            $table->string('direction');
            $table->string('phone_number');
            $table->text('content')->nullable();
            $table->string('status');
            $table->integer('duration')->nullable();
            $table->decimal('cost', 10, 2)->nullable();
            $table->foreignId('company_id')->constrained('companies');
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('communication_logs'); }
};
