<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up(): void {
        Schema::create('content_optimizations', function (Blueprint $table) {
            $table->id();
            $table->text('original_text');
            $table->text('optimized_text');
            $table->json('scores')->nullable();
            $table->json('suggestions')->nullable();
            $table->json('improvements')->nullable();
            $table->foreignId('user_id')->constrained('users');
            $table->foreignId('company_id')->constrained('companies');
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('content_optimizations'); }
};
