<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('modules') && !Schema::hasColumn('modules', 'slug')) {
            Schema::table('modules', function (Blueprint $table) {
                $table->string('slug')->unique()->nullable()->after('name');
                $table->string('route')->nullable()->after('path');
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasTable('modules')) {
            Schema::table('modules', function (Blueprint $table) {
                if (Schema::hasColumn('modules', 'slug')) {
                    $table->dropColumn('slug');
                }
                if (Schema::hasColumn('modules', 'route')) {
                    $table->dropColumn('route');
                }
            });
        }
    }
};
