<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('email_templates') && !Schema::hasColumn('email_templates', 'user_id')) {
            Schema::table('email_templates', function (Blueprint $table) {
                $table->foreignId('user_id')->nullable()->constrained()->onDelete('cascade')->after('id');
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasTable('email_templates') && Schema::hasColumn('email_templates', 'user_id')) {
            Schema::table('email_templates', function (Blueprint $table) {
                $table->dropForeignKeyIfExists(['user_id']);
                $table->dropColumn('user_id');
            });
        }
    }
};
