<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('team_messages', function (Blueprint $table) {
            if (!Schema::hasColumn('team_messages', 'company_id')) {
                $table->foreignId('company_id')->after('id')->constrained('companies')->onDelete('cascade');
                $table->index(['company_id', 'created_at']);
            }
        });
    }

    public function down(): void
    {
        Schema::table('team_messages', function (Blueprint $table) {
            $table->dropForeign(['company_id']);
            $table->dropColumn('company_id');
        });
    }
};
