<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('team_messages', function (Blueprint $table) {
            if (!Schema::hasColumn('team_messages', 'message')) {
                $table->text('message')->after('user_id');
            }
            if (!Schema::hasColumn('team_messages', 'type')) {
                $table->string('type')->default('text')->after('message');
            }
            if (!Schema::hasColumn('team_messages', 'attachment_url')) {
                $table->string('attachment_url')->nullable()->after('type');
            }
        });
    }

    public function down(): void
    {
        Schema::table('team_messages', function (Blueprint $table) {
            $table->dropColumn(['message', 'type', 'attachment_url']);
        });
    }
};
