<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('team_messages', function (Blueprint $table) {
            if (Schema::hasColumn('team_messages', 'company_id')) {
                $table->unsignedBigInteger('company_id')->nullable()->change();
            }
        });
    }

    public function down(): void
    {
        Schema::table('team_messages', function (Blueprint $table) {
            if (Schema::hasColumn('team_messages', 'company_id')) {
                $table->unsignedBigInteger('company_id')->nullable(false)->change();
            }
        });
    }
};
