<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        // Make all extra columns nullable
        Schema::table('team_messages', function (Blueprint $table) {
            if (Schema::hasColumn('team_messages', 'message')) {
                $table->text('message')->nullable()->change();
            }
            if (Schema::hasColumn('team_messages', 'attachment_url')) {
                $table->string('attachment_url')->nullable()->change();
            }
            if (Schema::hasColumn('team_messages', 'is_read')) {
                $table->boolean('is_read')->nullable()->default(false)->change();
            }
        });
    }

    public function down(): void
    {
        Schema::table('team_messages', function (Blueprint $table) {
            if (Schema::hasColumn('team_messages', 'message')) {
                $table->text('message')->nullable(false)->change();
            }
        });
    }
};
