<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('team_messages', function (Blueprint $table) {
            if (!Schema::hasColumn('team_messages', 'file_url')) {
                $table->string('file_url')->nullable()->after('content');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('team_messages', function (Blueprint $table) {
            if (Schema::hasColumn('team_messages', 'file_url')) {
                $table->dropColumn('file_url');
            }
        });
    }
};
