<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\AIAgent;
use App\Models\User;

class ContentCreatorAgentSeeder extends Seeder
{
    /**
     * Seed a sample Content Creator AI Agent for testing
     * 
     * Run with: php artisan db:seed --class=ContentCreatorAgentSeeder
     */
    public function run(): void
    {
        // Get the first user (or create one if none exists)
        $user = User::first();
        
        if (!$user) {
            echo "❌ No users found. Please create a user first.\n";
            return;
        }

        // Check if agent already exists
        $existingAgent = AIAgent::where('user_id', $user->id)
            ->where('type', 'CONTENT_CREATOR')
            ->first();

        if ($existingAgent) {
            echo "ℹ️  Content Creator agent already exists: {$existingAgent->name}\n";
            return;
        }

        // Create the Content Creator agent
        $agent = AIAgent::create([
            'user_id' => $user->id,
            'name' => 'Social Media Content Creator',
            'type' => 'CONTENT_CREATOR',
            'prompt' => 'You are a creative social media content creator specializing in engaging posts for Instagram, Facebook, Twitter, and LinkedIn. Your posts are:

- Concise and impactful (under 280 characters for Twitter, under 2200 for others)
- Include relevant emojis to add personality
- Use 3-5 relevant hashtags
- Have a clear call-to-action when appropriate
- Match the tone and style of each platform
- Are optimized for engagement

When creating content, consider:
- Target audience and demographics
- Platform-specific best practices
- Current trends and topics
- Brand voice and messaging
- Visual appeal (since images will be generated)

Always aim to create content that stops the scroll and encourages interaction.',
            'model' => 'llama-3.1-70b-versatile', // Groq's Llama model
            'is_active' => true,
            'settings' => [
                'temperature' => 0.8,
                'max_tokens' => 500,
                'features' => [
                    'image_generation' => true,
                    'hashtag_suggestions' => true,
                    'emoji_usage' => true
                ]
            ]
        ]);

        echo "✅ Content Creator agent created successfully!\n";
        echo "   Name: {$agent->name}\n";
        echo "   Type: {$agent->type}\n";
        echo "   Model: {$agent->model}\n";
        echo "   User: {$user->name} ({$user->email})\n";
        echo "\n";
        echo "🎉 You can now use this agent at: /ai-chat\n";
        echo "💡 Try prompts like:\n";
        echo "   - 'Create an Instagram post about morning coffee'\n";
        echo "   - 'Write a LinkedIn post about productivity tips'\n";
        echo "   - 'Generate a Facebook post about healthy eating'\n";
    }
}
