<?php

namespace Database\Seeders;

use App\Models\Conversation;
use App\Models\User;
use Illuminate\Database\Seeder;

class ConversationSeeder extends Seeder
{
    public function run(): void
    {
        $users = User::all();
        
        if ($users->count() < 2) return;

        Conversation::create([
            'company_id' => 1,
            'user_id' => $users->first()->id,
            'contact_id' => 1,
            'subject' => 'Initial Contact Discussion',
            'status' => 'OPEN',
        ]);

        Conversation::create([
            'company_id' => 1,
            'user_id' => $users->last()->id,
            'contact_id' => 2,
            'subject' => 'Follow-up Meeting',
            'status' => 'OPEN',
        ]);
    }
}
