<?php

namespace Database\Seeders;

use App\Models\EmailTemplate;
use App\Models\User;
use Illuminate\Database\Seeder;

class EmailTemplateSeeder extends Seeder
{
    public function run(): void
    {
        $user = User::first();
        
        if (!$user) return;

        EmailTemplate::create([
            'user_id' => $user->id,
            'name' => 'Welcome Email',
            'subject' => 'Welcome to SocialLead',
            'content' => 'Hello {{name}}, welcome to our platform!',
        ]);

        EmailTemplate::create([
            'user_id' => $user->id,
            'name' => 'Follow-up Email',
            'subject' => 'Following up on our conversation',
            'content' => 'Hi {{name}}, I wanted to follow up on our recent discussion.',
        ]);
    }
}
