<?php

namespace Database\Seeders;

use App\Models\Module;
use Illuminate\Database\Seeder;

class ModuleSeeder extends Seeder
{
    public function run(): void
    {
        $modules = [
            [
                'name' => 'dashboard',
                'slug' => 'dashboard',
                'display_name' => 'Dashboard',
                'description' => 'Main dashboard with overview and analytics',
                'icon' => 'dashboard',
                'path' => '/dashboard',
                'route' => 'dashboard',
                'category' => 'core',
                'is_active' => true,
                'sort_order' => 1
            ],
            [
                'name' => 'contacts',
                'slug' => 'contacts',
                'display_name' => 'Contacts',
                'description' => 'Manage your contacts and leads',
                'icon' => 'contacts',
                'path' => '/contacts',
                'route' => 'contacts.index',
                'category' => 'crm',
                'is_active' => true,
                'sort_order' => 2
            ],
            [
                'name' => 'opportunities',
                'slug' => 'opportunities',
                'display_name' => 'Opportunities',
                'description' => 'Track sales opportunities',
                'icon' => 'trending_up',
                'path' => '/opportunities',
                'route' => 'opportunities.index',
                'category' => 'crm',
                'is_active' => true,
                'sort_order' => 3
            ],
            [
                'name' => 'conversations',
                'slug' => 'conversations',
                'display_name' => 'Conversations',
                'description' => 'Manage conversations with contacts',
                'icon' => 'chat',
                'path' => '/conversations',
                'route' => 'conversations.index',
                'category' => 'communication',
                'is_active' => true,
                'sort_order' => 4
            ],
            [
                'name' => 'campaigns',
                'slug' => 'campaigns',
                'display_name' => 'Campaigns',
                'description' => 'Create and manage marketing campaigns',
                'icon' => 'campaign',
                'path' => '/campaigns',
                'route' => 'campaigns.index',
                'category' => 'marketing',
                'is_active' => true,
                'sort_order' => 5
            ],
            [
                'name' => 'social-posts',
                'slug' => 'social-posts',
                'display_name' => 'Social Posts',
                'description' => 'Manage social media posts',
                'icon' => 'share',
                'path' => '/social-posts',
                'route' => 'social-posts.index',
                'category' => 'social',
                'is_active' => true,
                'sort_order' => 6
            ],
            [
                'name' => 'email-campaigns',
                'slug' => 'email-campaigns',
                'display_name' => 'Email Campaigns',
                'description' => 'Create and send email campaigns',
                'icon' => 'mail',
                'path' => '/email-campaigns',
                'route' => 'email-campaigns.index',
                'category' => 'marketing',
                'is_active' => true,
                'sort_order' => 7
            ],
            [
                'name' => 'ai-agents',
                'slug' => 'ai-agents',
                'display_name' => 'AI Agents',
                'description' => 'Manage AI agents for automation',
                'icon' => 'smart_toy',
                'path' => '/ai-agents',
                'route' => 'ai-agents.index',
                'category' => 'ai',
                'is_active' => true,
                'sort_order' => 8
            ],
            [
                'name' => 'ai-chat',
                'slug' => 'ai-chat',
                'display_name' => 'AI Chat',
                'description' => 'Chat with AI agents and generate content with images',
                'icon' => 'chat_bubble',
                'path' => '/ai-chat',
                'route' => 'ai-chat.index',
                'category' => 'ai',
                'is_active' => true,
                'sort_order' => 9
            ],
            [
                'name' => 'calendar',
                'slug' => 'calendar',
                'display_name' => 'Calendar',
                'description' => 'Manage events and appointments',
                'icon' => 'calendar_today',
                'path' => '/calendar',
                'route' => 'calendar.index',
                'category' => 'productivity',
                'is_active' => true,
                'sort_order' => 10
            ],
            [
                'name' => 'team',
                'slug' => 'team',
                'display_name' => 'Team',
                'description' => 'Manage team members and collaboration',
                'icon' => 'group',
                'path' => '/team',
                'route' => 'team.index',
                'category' => 'collaboration',
                'is_active' => true,
                'sort_order' => 11
            ],
            [
                'name' => 'media',
                'slug' => 'media',
                'display_name' => 'Media Library',
                'description' => 'Manage media files and assets',
                'icon' => 'photo_library',
                'path' => '/media',
                'route' => 'media.index',
                'category' => 'content',
                'is_active' => true,
                'sort_order' => 12
            ],
            [
                'name' => 'reviews',
                'slug' => 'reviews',
                'display_name' => 'Reviews',
                'description' => 'Manage customer reviews',
                'icon' => 'star',
                'path' => '/reviews',
                'route' => 'reviews.index',
                'category' => 'reputation',
                'is_active' => true,
                'sort_order' => 13
            ],
            [
                'name' => 'settings',
                'slug' => 'settings',
                'display_name' => 'Settings',
                'description' => 'Configure system settings',
                'icon' => 'settings',
                'path' => '/settings',
                'route' => 'settings.index',
                'category' => 'system',
                'is_active' => true,
                'sort_order' => 14
            ],
            [
                'name' => 'pipelines',
                'slug' => 'pipelines',
                'display_name' => 'Pipelines',
                'description' => 'Visual pipeline and funnel builder',
                'icon' => 'account_tree',
                'path' => '/pipelines',
                'route' => 'pipelines.index',
                'category' => 'sales',
                'is_active' => true,
                'sort_order' => 15
            ],
            [
                'name' => 'deals',
                'slug' => 'deals',
                'display_name' => 'Deals',
                'description' => 'Manage deals and track progress',
                'icon' => 'handshake',
                'path' => '/deals',
                'route' => 'deals.index',
                'category' => 'sales',
                'is_active' => true,
                'sort_order' => 16
            ],
        ];

        foreach ($modules as $module) {
            Module::firstOrCreate(['name' => $module['name']], $module);
        }
    }
}
