<?php

namespace Database\Seeders;

use App\Models\Review;
use App\Models\User;
use Illuminate\Database\Seeder;

class ReviewSeeder extends Seeder
{
    public function run(): void
    {
        $user = User::first();
        
        if (!$user || !$user->company_id) return;

        Review::create([
            'company_id' => $user->company_id,
            'customer_name' => 'John Smith',
            'customer_email' => 'john.smith@example.com',
            'rating' => 5,
            'comment' => 'Excellent service and support',
            'platform' => 'Google',
        ]);

        Review::create([
            'company_id' => $user->company_id,
            'customer_name' => 'Sarah Johnson',
            'customer_email' => 'sarah.j@example.com',
            'rating' => 4,
            'comment' => 'Good experience overall',
            'platform' => 'Facebook',
        ]);
    }
}
