<?php

namespace Database\Seeders;

use App\Models\Subscription;
use App\Models\User;
use Illuminate\Database\Seeder;

class SubscriptionSeeder extends Seeder
{
    public function run(): void
    {
        $user = User::first();
        
        if (!$user || !$user->company_id) return;

        Subscription::create([
            'company_id' => $user->company_id,
            'plan' => 'Pro Plan',
            'status' => 'ACTIVE',
            'current_period_start' => now(),
            'current_period_end' => now()->addYear(),
            'cancel_at_period_end' => false,
        ]);
    }
}
