<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    public function run(): void
    {
        User::create([
            'name' => 'Admin User',
            'email' => 'admin@sociallead.com',
            'password' => Hash::make('password123'),
            'role' => 'ADMIN',
            'company_id' => 1,
            'is_active' => true,
        ]);

        User::create([
            'name' => 'Demo User',
            'email' => 'user@sociallead.com',
            'password' => Hash::make('password123'),
            'role' => 'USER',
            'company_id' => 1,
            'is_active' => true,
        ]);
    }
}
