@echo off
REM Laravel Deployment Script for Windows
REM Run this script after uploading files to server

echo ========================================
echo   Laravel Deployment Script
echo ========================================
echo.

REM Check if .env exists
if not exist .env (
    echo [ERROR] .env file not found!
    echo Copying .env.example to .env...
    copy .env.example .env
    echo [WARNING] Please configure .env file with your settings
    pause
    exit /b 1
)

REM Check PHP
echo [INFO] Checking PHP version...
php -v
echo.

REM Install Composer dependencies
echo [INFO] Installing Composer dependencies...
composer install --optimize-autoloader --no-dev
if %errorlevel% neq 0 (
    echo [WARNING] Composer install failed or composer not found
)
echo.

REM Generate application key
echo [INFO] Checking application key...
findstr /C:"APP_KEY=base64:" .env >nul
if %errorlevel% neq 0 (
    echo [INFO] Generating application key...
    php artisan key:generate
)
echo.

REM Clear caches
echo [INFO] Clearing caches...
php artisan cache:clear
php artisan config:clear
php artisan route:clear
php artisan view:clear
echo.

REM Create storage symlink
echo [INFO] Creating storage symlink...
php artisan storage:link
echo.

REM Run migrations
echo.
set /p migrate="Do you want to run migrations? (y/n): "
if /i "%migrate%"=="y" (
    echo [INFO] Running migrations...
    php artisan migrate --force
)
echo.

REM Seed database
set /p seed="Do you want to seed the database? (y/n): "
if /i "%seed%"=="y" (
    echo [INFO] Seeding database...
    php artisan db:seed --force
)
echo.

REM Optimize for production
echo [INFO] Optimizing for production...
php artisan config:cache
php artisan route:cache
php artisan view:cache
echo.

REM Build frontend assets
if exist package.json (
    set /p build="Do you want to build frontend assets? (y/n): "
    if /i "%build%"=="y" (
        echo [INFO] Building frontend assets...
        call npm install
        call npm run build
    )
)
echo.

REM Final checks
echo ========================================
echo   Final Checks
echo ========================================
echo.

findstr /C:"APP_DEBUG=true" .env >nul
if %errorlevel% equ 0 (
    echo [ERROR] APP_DEBUG is set to true!
    echo [WARNING] Please set APP_DEBUG=false in .env for production
)

findstr /C:"APP_ENV=production" .env >nul
if %errorlevel% neq 0 (
    echo [WARNING] APP_ENV is not set to production
)

if exist public\storage (
    echo [OK] Storage symlink exists
) else (
    echo [WARNING] Storage symlink not found
)

echo.
echo ========================================
echo   Deployment Completed!
echo ========================================
echo.
echo Post-deployment checklist:
echo   1. Verify .env configuration
echo   2. Set APP_DEBUG=false
echo   3. Set APP_ENV=production
echo   4. Configure database credentials
echo   5. Set up SMTP for emails
echo   6. Verify document root points to /public
echo   7. Test the application
echo.
echo For troubleshooting, see: DEPLOYMENT_TROUBLESHOOTING.md
echo.
pause
