<?php
/**
 * Laravel Deployment Diagnostic Script
 * 
 * Upload this file to your server's public directory
 * Access it via: https://your-domain.com/diagnose.php
 * 
 * This will help identify deployment issues
 * DELETE THIS FILE after diagnosing!
 */

header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html>
<head>
    <title>Laravel Deployment Diagnostics</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; background: #f5f5f5; }
        .container { max-width: 900px; margin: 0 auto; background: white; padding: 30px; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
        h1 { color: #333; border-bottom: 3px solid #3490dc; padding-bottom: 10px; }
        h2 { color: #555; margin-top: 30px; border-bottom: 2px solid #e3e8ee; padding-bottom: 8px; }
        .check { margin: 15px 0; padding: 12px; border-radius: 4px; }
        .success { background: #d4edda; border-left: 4px solid #28a745; color: #155724; }
        .error { background: #f8d7da; border-left: 4px solid #dc3545; color: #721c24; }
        .warning { background: #fff3cd; border-left: 4px solid #ffc107; color: #856404; }
        .info { background: #d1ecf1; border-left: 4px solid #17a2b8; color: #0c5460; }
        .icon { font-weight: bold; margin-right: 8px; }
        code { background: #f4f4f4; padding: 2px 6px; border-radius: 3px; font-family: monospace; }
        .delete-warning { background: #dc3545; color: white; padding: 15px; border-radius: 4px; margin-top: 30px; text-align: center; font-weight: bold; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔍 Laravel Deployment Diagnostics</h1>
        <p>This script checks common deployment issues. <strong>Delete this file after use!</strong></p>

        <h2>1. PHP Configuration</h2>
        <?php
        // PHP Version
        $phpVersion = PHP_VERSION;
        $phpVersionOk = version_compare($phpVersion, '8.2.0', '>=');
        ?>
        <div class="check <?php echo $phpVersionOk ? 'success' : 'error'; ?>">
            <span class="icon"><?php echo $phpVersionOk ? '✓' : '✗'; ?></span>
            <strong>PHP Version:</strong> <?php echo $phpVersion; ?>
            <?php if (!$phpVersionOk): ?>
                <br><small>Laravel 12 requires PHP 8.2 or higher</small>
            <?php endif; ?>
        </div>

        <?php
        // Required Extensions
        $requiredExtensions = ['bcmath', 'ctype', 'fileinfo', 'json', 'mbstring', 'openssl', 'pdo', 'tokenizer', 'xml'];
        $missingExtensions = [];
        foreach ($requiredExtensions as $ext) {
            if (!extension_loaded($ext)) {
                $missingExtensions[] = $ext;
            }
        }
        ?>
        <div class="check <?php echo empty($missingExtensions) ? 'success' : 'error'; ?>">
            <span class="icon"><?php echo empty($missingExtensions) ? '✓' : '✗'; ?></span>
            <strong>Required PHP Extensions:</strong>
            <?php if (empty($missingExtensions)): ?>
                All required extensions are installed
            <?php else: ?>
                Missing: <?php echo implode(', ', $missingExtensions); ?>
            <?php endif; ?>
        </div>

        <h2>2. File System</h2>
        <?php
        // Check if we're in the right directory
        $laravelRoot = dirname(__DIR__);
        $isLaravelRoot = file_exists($laravelRoot . '/artisan');
        ?>
        <div class="check <?php echo $isLaravelRoot ? 'success' : 'error'; ?>">
            <span class="icon"><?php echo $isLaravelRoot ? '✓' : '✗'; ?></span>
            <strong>Laravel Root:</strong>
            <?php if ($isLaravelRoot): ?>
                Found at <?php echo $laravelRoot; ?>
            <?php else: ?>
                Cannot find Laravel installation. Make sure this file is in the public/ directory.
            <?php endif; ?>
        </div>

        <?php if ($isLaravelRoot): ?>
            <?php
            // Check .env file
            $envExists = file_exists($laravelRoot . '/.env');
            ?>
            <div class="check <?php echo $envExists ? 'success' : 'error'; ?>">
                <span class="icon"><?php echo $envExists ? '✓' : '✗'; ?></span>
                <strong>.env File:</strong>
                <?php if ($envExists): ?>
                    Found
                <?php else: ?>
                    Missing! Copy .env.example to .env and configure it.
                <?php endif; ?>
            </div>

            <?php
            // Check storage directory
            $storageWritable = is_writable($laravelRoot . '/storage');
            ?>
            <div class="check <?php echo $storageWritable ? 'success' : 'error'; ?>">
                <span class="icon"><?php echo $storageWritable ? '✓' : '✗'; ?></span>
                <strong>Storage Directory:</strong>
                <?php if ($storageWritable): ?>
                    Writable
                <?php else: ?>
                    Not writable! Run: <code>chmod -R 775 storage</code>
                <?php endif; ?>
            </div>

            <?php
            // Check bootstrap/cache directory
            $cacheWritable = is_writable($laravelRoot . '/bootstrap/cache');
            ?>
            <div class="check <?php echo $cacheWritable ? 'success' : 'error'; ?>">
                <span class="icon"><?php echo $cacheWritable ? '✓' : '✗'; ?></span>
                <strong>Bootstrap Cache:</strong>
                <?php if ($cacheWritable): ?>
                    Writable
                <?php else: ?>
                    Not writable! Run: <code>chmod -R 775 bootstrap/cache</code>
                <?php endif; ?>
            </div>

            <?php
            // Check vendor directory
            $vendorExists = is_dir($laravelRoot . '/vendor');
            ?>
            <div class="check <?php echo $vendorExists ? 'success' : 'error'; ?>">
                <span class="icon"><?php echo $vendorExists ? '✓' : '✗'; ?></span>
                <strong>Composer Dependencies:</strong>
                <?php if ($vendorExists): ?>
                    Installed
                <?php else: ?>
                    Missing! Run: <code>composer install --optimize-autoloader --no-dev</code>
                <?php endif; ?>
            </div>

            <?php
            // Check storage symlink
            $symlinkExists = is_link(__DIR__ . '/storage');
            ?>
            <div class="check <?php echo $symlinkExists ? 'success' : 'warning'; ?>">
                <span class="icon"><?php echo $symlinkExists ? '✓' : '⚠'; ?></span>
                <strong>Storage Symlink:</strong>
                <?php if ($symlinkExists): ?>
                    Created
                <?php else: ?>
                    Missing. Run: <code>php artisan storage:link</code>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <h2>3. Web Server</h2>
        <div class="check info">
            <span class="icon">ℹ</span>
            <strong>Server Software:</strong> <?php echo $_SERVER['SERVER_SOFTWARE'] ?? 'Unknown'; ?>
        </div>

        <div class="check info">
            <span class="icon">ℹ</span>
            <strong>Document Root:</strong> <?php echo $_SERVER['DOCUMENT_ROOT'] ?? 'Unknown'; ?>
        </div>

        <?php
        // Check if mod_rewrite is enabled (Apache)
        if (function_exists('apache_get_modules')) {
            $modRewrite = in_array('mod_rewrite', apache_get_modules());
            ?>
            <div class="check <?php echo $modRewrite ? 'success' : 'error'; ?>">
                <span class="icon"><?php echo $modRewrite ? '✓' : '✗'; ?></span>
                <strong>mod_rewrite:</strong>
                <?php if ($modRewrite): ?>
                    Enabled
                <?php else: ?>
                    Disabled or not detected. Contact your hosting provider.
                <?php endif; ?>
            </div>
        <?php } ?>

        <h2>4. Laravel Configuration</h2>
        <?php if ($isLaravelRoot && $envExists): ?>
            <?php
            // Read .env file
            $envContent = file_get_contents($laravelRoot . '/.env');
            
            // Check APP_KEY
            $hasAppKey = preg_match('/APP_KEY=base64:.+/', $envContent);
            ?>
            <div class="check <?php echo $hasAppKey ? 'success' : 'error'; ?>">
                <span class="icon"><?php echo $hasAppKey ? '✓' : '✗'; ?></span>
                <strong>APP_KEY:</strong>
                <?php if ($hasAppKey): ?>
                    Set
                <?php else: ?>
                    Not set! Run: <code>php artisan key:generate</code>
                <?php endif; ?>
            </div>

            <?php
            // Check APP_DEBUG
            $debugEnabled = preg_match('/APP_DEBUG=true/', $envContent);
            ?>
            <div class="check <?php echo !$debugEnabled ? 'success' : 'warning'; ?>">
                <span class="icon"><?php echo !$debugEnabled ? '✓' : '⚠'; ?></span>
                <strong>APP_DEBUG:</strong>
                <?php if (!$debugEnabled): ?>
                    Disabled (Good for production)
                <?php else: ?>
                    Enabled! Set to <code>false</code> in production
                <?php endif; ?>
            </div>

            <?php
            // Check APP_ENV
            $isProduction = preg_match('/APP_ENV=production/', $envContent);
            ?>
            <div class="check <?php echo $isProduction ? 'success' : 'warning'; ?>">
                <span class="icon"><?php echo $isProduction ? '✓' : '⚠'; ?></span>
                <strong>APP_ENV:</strong>
                <?php if ($isProduction): ?>
                    Set to production
                <?php else: ?>
                    Not set to production. Should be <code>production</code> on live server
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <h2>5. Recommendations</h2>
        <div class="check info">
            <span class="icon">💡</span>
            <strong>Next Steps:</strong>
            <ul style="margin: 10px 0 0 30px;">
                <li>Run: <code>php artisan migrate --force</code> to set up database</li>
                <li>Run: <code>php artisan config:cache</code> to optimize configuration</li>
                <li>Run: <code>php artisan route:cache</code> to optimize routes</li>
                <li>Run: <code>php artisan view:cache</code> to optimize views</li>
                <li>Ensure document root points to <code>/public</code> directory</li>
                <li>Set up SSL certificate (HTTPS)</li>
            </ul>
        </div>

        <div class="delete-warning">
            ⚠️ DELETE THIS FILE (diagnose.php) AFTER USE! ⚠️
            <br><small>This file exposes sensitive server information</small>
        </div>

        <p style="text-align: center; margin-top: 30px; color: #666;">
            <small>For more help, see: <strong>DEPLOYMENT_TROUBLESHOOTING.md</strong></small>
        </p>
    </div>
</body>
</html>
