@extends('layouts.app')

@section('title', $agent->name)
@section('page-title', $agent->name)

@section('content')
<div class="max-w-4xl mx-auto">
    <div class="bg-white rounded-lg shadow">
        <div class="px-6 py-4 border-b border-gray-200 flex justify-between items-center">
            <div>
                <h2 class="text-2xl font-bold text-gray-900">{{ $agent->name }}</h2>
                <p class="text-sm text-gray-600 mt-1">Type: <span class="font-medium">{{ str_replace('_', ' ', $agent->type) }}</span></p>
            </div>
            <div class="flex gap-2">
                <a href="{{ route('ai-agents.edit', $agent->id) }}" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                    Edit
                </a>
                <form action="{{ route('ai-agents.destroy', $agent->id) }}" method="POST" class="inline" onsubmit="return confirm('Are you sure?')">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="px-4 py-2 bg-red-600 text-white rounded-lg hover:bg-red-700">
                        Delete
                    </button>
                </form>
            </div>
        </div>

        <div class="p-6 space-y-6">
            <div>
                <h3 class="text-sm font-semibold text-gray-900 mb-2">Model</h3>
                <p class="text-gray-700">{{ $agent->model }}</p>
            </div>

            <div>
                <h3 class="text-sm font-semibold text-gray-900 mb-2">Status</h3>
                <span class="inline-block px-3 py-1 rounded-full text-sm font-medium {{ $agent->is_active ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">
                    {{ $agent->is_active ? 'Active' : 'Inactive' }}
                </span>
            </div>

            <div>
                <h3 class="text-sm font-semibold text-gray-900 mb-2">Prompt</h3>
                <div class="bg-gray-50 p-4 rounded-lg border border-gray-200 whitespace-pre-wrap text-sm text-gray-700">
                    {{ $agent->prompt }}
                </div>
            </div>

            @if($agent->settings)
                <div>
                    <h3 class="text-sm font-semibold text-gray-900 mb-2">Settings</h3>
                    <pre class="bg-gray-50 p-4 rounded-lg border border-gray-200 text-sm overflow-auto">{{ json_encode($agent->settings, JSON_PRETTY_PRINT) }}</pre>
                </div>
            @endif

            <div class="text-sm text-gray-500">
                <p>Created: {{ $agent->created_at->format('M d, Y H:i') }}</p>
                <p>Updated: {{ $agent->updated_at->format('M d, Y H:i') }}</p>
            </div>
        </div>
    </div>

    <div class="mt-6">
        <a href="{{ route('ai-agents.index') }}" class="text-blue-600 hover:text-blue-900">
            ← Back to AI Agents
        </a>
    </div>
</div>
@endsection
