@extends('layouts.app')

@section('title', 'Audit Logs')
@section('page-title', 'Audit Logs')

@section('content')
<div class="bg-white rounded-lg shadow">
    <div class="px-6 py-4 border-b border-gray-200">
        <h2 class="text-lg font-semibold text-gray-900">System Audit Logs</h2>
    </div>

    <div class="overflow-x-auto">
        <table class="w-full">
            <thead class="bg-gray-50 border-b border-gray-200">
                <tr>
                    <th class="px-6 py-3 text-left text-sm font-semibold text-gray-900">User</th>
                    <th class="px-6 py-3 text-left text-sm font-semibold text-gray-900">Action</th>
                    <th class="px-6 py-3 text-left text-sm font-semibold text-gray-900">Resource</th>
                    <th class="px-6 py-3 text-left text-sm font-semibold text-gray-900">IP Address</th>
                    <th class="px-6 py-3 text-left text-sm font-semibold text-gray-900">Date</th>
                </tr>
            </thead>
            <tbody>
                @forelse($logs as $log)
                    <tr class="border-b border-gray-200 hover:bg-gray-50">
                        <td class="px-6 py-4 text-sm text-gray-900">{{ $log->user->name ?? 'System' }}</td>
                        <td class="px-6 py-4 text-sm">
                            <span class="px-2 py-1 rounded text-xs font-medium
                                {{ $log->action === 'created' ? 'bg-green-100 text-green-800' : '' }}
                                {{ $log->action === 'updated' ? 'bg-blue-100 text-blue-800' : '' }}
                                {{ $log->action === 'deleted' ? 'bg-red-100 text-red-800' : '' }}
                            ">
                                {{ ucfirst($log->action) }}
                            </span>
                        </td>
                        <td class="px-6 py-4 text-sm text-gray-600">{{ $log->resource ?? 'N/A' }}</td>
                        <td class="px-6 py-4 text-sm text-gray-600">{{ $log->ip_address ?? '-' }}</td>
                        <td class="px-6 py-4 text-sm text-gray-600">{{ $log->created_at->format('M d, Y H:i') }}</td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="5" class="px-6 py-8 text-center text-gray-500">
                            No audit logs found
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    @if($logs->hasPages())
        <div class="px-6 py-4 border-t border-gray-200">
            {{ $logs->links() }}
        </div>
    @endif
</div>
@endsection
