@extends('layouts.app')

@section('title', 'Calendar')
@section('page-title', 'Calendar Events')

@section('content')
<div class="bg-white rounded-lg shadow">
    <div class="px-6 py-4 border-b border-gray-200 flex justify-between items-center">
        <h2 class="text-lg font-semibold text-gray-900">Calendar Events</h2>
        <a href="{{ route('calendar.create') }}" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
            + Create Event
        </a>
    </div>

    <div class="p-6">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
            @forelse($events as $event)
                <div class="border rounded-lg p-4 hover:shadow-lg transition-shadow" style="border-left: 4px solid {{ $event->color ?? '#3b82f6' }}">
                    <h3 class="font-semibold text-gray-900">{{ $event->title }}</h3>
                    <p class="text-sm text-gray-600 mt-1">{{ $event->description }}</p>
                    
                    <div class="mt-3 space-y-1 text-sm text-gray-600">
                        <p><i class="fas fa-calendar mr-2"></i>{{ \Carbon\Carbon::parse($event->start_date)->format('M d, Y') }}</p>
                        @if($event->location)
                            <p><i class="fas fa-map-marker-alt mr-2"></i>{{ $event->location }}</p>
                        @endif
                    </div>

                    <div class="mt-4 flex gap-2">
                        <a href="{{ route('calendar.show', $event->id) }}" class="text-blue-600 hover:text-blue-900 text-sm font-medium">View</a>
                        <a href="{{ route('calendar.edit', $event->id) }}" class="text-blue-600 hover:text-blue-900 text-sm font-medium">Edit</a>
                        <form action="{{ route('calendar.destroy', $event->id) }}" method="POST" class="inline" onsubmit="return confirm('Delete this event?')">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="text-red-600 hover:text-red-900 text-sm font-medium">Delete</button>
                        </form>
                    </div>
                </div>
            @empty
                <div class="col-span-full text-center py-8 text-gray-500">
                    No events found
                </div>
            @endforelse
        </div>
    </div>
</div>
@endsection
