@extends('layouts.app')

@section('title', $event->title)
@section('page-title', $event->title)

@section('content')
<div class="bg-white rounded-lg shadow">
    <div class="px-6 py-4 border-b border-gray-200 flex justify-between items-center" style="border-left: 4px solid {{ $event->color ?? '#3b82f6' }}">
        <div>
            <h2 class="text-2xl font-bold text-gray-900">{{ $event->title }}</h2>
        </div>
        <div class="flex gap-2">
            <a href="{{ route('calendar.edit', $event->id) }}" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                Edit
            </a>
            <form action="{{ route('calendar.destroy', $event->id) }}" method="POST" class="inline" onsubmit="return confirm('Delete this event?')">
                @csrf
                @method('DELETE')
                <button type="submit" class="px-4 py-2 bg-red-600 text-white rounded-lg hover:bg-red-700">
                    Delete
                </button>
            </form>
        </div>
    </div>

    <div class="p-6 space-y-6">
        <div>
            <h3 class="text-sm font-semibold text-gray-900 mb-2">Description</h3>
            <p class="text-gray-700">{{ $event->description ?? 'No description' }}</p>
        </div>

        <div class="grid grid-cols-2 gap-4">
            <div>
                <h3 class="text-sm font-semibold text-gray-900 mb-2">Start Date</h3>
                <p class="text-gray-700">{{ \Carbon\Carbon::parse($event->start_date)->format('M d, Y H:i') }}</p>
            </div>
            <div>
                <h3 class="text-sm font-semibold text-gray-900 mb-2">End Date</h3>
                <p class="text-gray-700">{{ \Carbon\Carbon::parse($event->end_date)->format('M d, Y H:i') }}</p>
            </div>
        </div>

        @if($event->location)
            <div>
                <h3 class="text-sm font-semibold text-gray-900 mb-2">Location</h3>
                <p class="text-gray-700">{{ $event->location }}</p>
            </div>
        @endif

        <div class="text-sm text-gray-500">
            <p>Created: {{ $event->created_at->format('M d, Y H:i') }}</p>
            <p>Updated: {{ $event->updated_at->format('M d, Y H:i') }}</p>
        </div>
    </div>
</div>

<div class="mt-6">
    <a href="{{ route('calendar.index') }}" class="text-blue-600 hover:text-blue-900">
        ← Back to Calendar
    </a>
</div>
@endsection
