@extends('layouts.app')

@section('title', 'Contact Details')
@section('page-title', 'Contact Details')

@section('content')
<div class="max-w-4xl mx-auto">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold text-gray-800">{{ $contact->first_name }} {{ $contact->last_name }}</h1>
        <div class="space-x-2">
            <a href="{{ route('contacts.edit', $contact) }}" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">Edit</a>
            <form method="POST" action="{{ route('contacts.destroy', $contact) }}" class="inline" onsubmit="return confirm('Are you sure?')">
                @csrf
                @method('DELETE')
                <button type="submit" class="px-4 py-2 bg-red-600 text-white rounded-lg hover:bg-red-700">Delete</button>
            </form>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <div class="lg:col-span-2">
            <div class="bg-white rounded-lg shadow p-6 mb-6">
                <h2 class="text-lg font-semibold text-gray-800 mb-4">Contact Information</h2>
                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <p class="text-sm text-gray-500">Email</p>
                        <p class="text-gray-800">{{ $contact->email }}</p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Phone</p>
                        <p class="text-gray-800">{{ $contact->phone ?? '-' }}</p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Job Title</p>
                        <p class="text-gray-800">{{ $contact->job_title ?? '-' }}</p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Company</p>
                        <p class="text-gray-800">{{ $contact->company_name ?? '-' }}</p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Status</p>
                        <span class="px-3 py-1 text-xs font-semibold rounded-full bg-blue-100 text-blue-800">{{ $contact->status }}</span>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Source</p>
                        <p class="text-gray-800">{{ $contact->source ?? '-' }}</p>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-lg shadow p-6">
                <h2 class="text-lg font-semibold text-gray-800 mb-4">Opportunities</h2>
                <div class="space-y-2">
                    @forelse($contact->opportunities as $opp)
                    <div class="flex justify-between items-center p-3 border border-gray-200 rounded">
                        <div>
                            <p class="font-medium text-gray-800">{{ $opp->title }}</p>
                            <p class="text-sm text-gray-500">{{ $opp->stage }}</p>
                        </div>
                        <a href="{{ route('opportunities.show', $opp) }}" class="text-blue-600 hover:text-blue-800">View</a>
                    </div>
                    @empty
                    <p class="text-gray-500">No opportunities</p>
                    @endforelse
                </div>
            </div>
        </div>

        <div>
            <div class="bg-white rounded-lg shadow p-6">
                <h2 class="text-lg font-semibold text-gray-800 mb-4">Quick Actions</h2>
                <div class="space-y-2">
                    <a href="{{ route('conversations.create', ['contact_id' => $contact->id]) }}" class="block w-full px-4 py-2 bg-blue-600 text-white rounded text-center hover:bg-blue-700">
                        <i class="fas fa-comment mr-2"></i> New Conversation
                    </a>
                    <a href="{{ route('opportunities.create', ['contact_id' => $contact->id]) }}" class="block w-full px-4 py-2 bg-green-600 text-white rounded text-center hover:bg-green-700">
                        <i class="fas fa-briefcase mr-2"></i> New Opportunity
                    </a>
                    <a href="{{ route('activities.create', ['contact_id' => $contact->id]) }}" class="block w-full px-4 py-2 bg-purple-600 text-white rounded text-center hover:bg-purple-700">
                        <i class="fas fa-tasks mr-2"></i> New Activity
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
