@extends('layouts.app')

@section('title', 'Dashboard')
@section('page-title', 'Dashboard')

@section('content')
<div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-gray-500 text-sm">Total Contacts</p>
                <p class="text-3xl font-bold text-gray-800">{{ $totalContacts ?? 0 }}</p>
            </div>
            <i class="fas fa-users text-4xl text-blue-500 opacity-20"></i>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-gray-500 text-sm">Open Opportunities</p>
                <p class="text-3xl font-bold text-gray-800">{{ $openOpportunities ?? 0 }}</p>
            </div>
            <i class="fas fa-briefcase text-4xl text-green-500 opacity-20"></i>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-gray-500 text-sm">Active Campaigns</p>
                <p class="text-3xl font-bold text-gray-800">{{ $activeCampaigns ?? 0 }}</p>
            </div>
            <i class="fas fa-bullhorn text-4xl text-purple-500 opacity-20"></i>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-gray-500 text-sm">Pending Tasks</p>
                <p class="text-3xl font-bold text-gray-800">{{ $pendingTasks ?? 0 }}</p>
            </div>
            <i class="fas fa-tasks text-4xl text-orange-500 opacity-20"></i>
        </div>
    </div>
</div>

<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    <div class="lg:col-span-2 bg-white rounded-lg shadow p-6">
        <h3 class="text-lg font-semibold text-gray-800 mb-4">Recent Contacts</h3>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-sm font-semibold text-gray-700">Name</th>
                        <th class="px-4 py-2 text-left text-sm font-semibold text-gray-700">Email</th>
                        <th class="px-4 py-2 text-left text-sm font-semibold text-gray-700">Status</th>
                        <th class="px-4 py-2 text-left text-sm font-semibold text-gray-700">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($recentContacts ?? [] as $contact)
                    <tr class="border-t">
                        <td class="px-4 py-3 text-sm">{{ $contact->first_name }} {{ $contact->last_name }}</td>
                        <td class="px-4 py-3 text-sm">{{ $contact->email }}</td>
                        <td class="px-4 py-3 text-sm">
                            <span class="px-2 py-1 text-xs font-semibold rounded-full bg-blue-100 text-blue-800">{{ $contact->status }}</span>
                        </td>
                        <td class="px-4 py-3 text-sm">
                            <a href="{{ route('contacts.show', $contact) }}" class="text-blue-600 hover:text-blue-800">View</a>
                        </td>
                    </tr>
                    @empty
                    <tr class="border-t">
                        <td colspan="4" class="px-4 py-3 text-center text-gray-500">No contacts yet</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow p-6">
        <h3 class="text-lg font-semibold text-gray-800 mb-4">Quick Actions</h3>
        <div class="space-y-2">
            <a href="{{ route('contacts.create') }}" class="block w-full px-4 py-2 bg-blue-600 text-white rounded hover:bg-blue-700 text-center">
                <i class="fas fa-plus mr-2"></i> New Contact
            </a>
            <a href="{{ route('opportunities.create') }}" class="block w-full px-4 py-2 bg-green-600 text-white rounded hover:bg-green-700 text-center">
                <i class="fas fa-plus mr-2"></i> New Opportunity
            </a>
            <a href="{{ route('campaigns.create') }}" class="block w-full px-4 py-2 bg-purple-600 text-white rounded hover:bg-purple-700 text-center">
                <i class="fas fa-plus mr-2"></i> New Campaign
            </a>
            <a href="{{ route('email-campaigns.create') }}" class="block w-full px-4 py-2 bg-orange-600 text-white rounded hover:bg-orange-700 text-center">
                <i class="fas fa-plus mr-2"></i> Email Campaign
            </a>
        </div>
    </div>
</div>
@endsection
