@extends('layouts.app')

@section('title', 'Edit Deal')
@section('page-title', 'Edit Deal')

@section('content')
<div class="max-w-3xl mx-auto">
    <div class="mb-6">
        <a href="{{ route('deals.show', $deal) }}" class="text-blue-600 hover:text-blue-700 flex items-center gap-2">
            <i class="fas fa-arrow-left"></i>
            Back to Deal
        </a>
    </div>

    <form action="{{ route('deals.update', $deal) }}" method="POST" class="bg-white rounded-lg shadow p-6">
        @csrf
        @method('PUT')

        <div class="space-y-6">
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Deal Title *</label>
                <input type="text" name="title" value="{{ $deal->title }}" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>

            <div class="grid grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Pipeline *</label>
                    <select name="pipeline_id" id="pipeline_id" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" onchange="loadStages(this.value)">
                        @foreach($pipelines as $pipeline)
                        <option value="{{ $pipeline->id }}" {{ $deal->pipeline_id == $pipeline->id ? 'selected' : '' }}>
                            {{ $pipeline->name }}
                        </option>
                        @endforeach
                    </select>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Stage *</label>
                    <select name="stage_id" id="stage_id" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        @foreach($deal->pipeline->stages as $stage)
                        <option value="{{ $stage->id }}" {{ $deal->stage_id == $stage->id ? 'selected' : '' }}>
                            {{ $stage->name }}
                        </option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Contact</label>
                <select name="contact_id" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">Select Contact (Optional)</option>
                    @foreach($contacts as $contact)
                    <option value="{{ $contact->id }}" {{ $deal->contact_id == $contact->id ? 'selected' : '' }}>
                        {{ $contact->name }}
                    </option>
                    @endforeach
                </select>
            </div>

            <div class="grid grid-cols-3 gap-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Value *</label>
                    <input type="number" name="value" value="{{ $deal->value }}" required min="0" step="0.01" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Currency *</label>
                    <select name="currency" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="USD" {{ $deal->currency == 'USD' ? 'selected' : '' }}>USD</option>
                        <option value="EUR" {{ $deal->currency == 'EUR' ? 'selected' : '' }}>EUR</option>
                        <option value="GBP" {{ $deal->currency == 'GBP' ? 'selected' : '' }}>GBP</option>
                    </select>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Probability (%) *</label>
                    <input type="number" name="probability" value="{{ $deal->probability }}" required min="0" max="100" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Expected Close Date</label>
                <input type="date" name="expected_close_date" value="{{ $deal->expected_close_date?->format('Y-m-d') }}" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Notes</label>
                <textarea name="notes" rows="4" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">{{ $deal->notes }}</textarea>
            </div>
        </div>

        <div class="flex gap-3 justify-end mt-6 pt-6 border-t border-gray-200">
            <a href="{{ route('deals.show', $deal) }}" class="px-6 py-2 border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50">
                Cancel
            </a>
            <button type="submit" class="px-6 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                Update Deal
            </button>
        </div>
    </form>
</div>

<script>
const pipelines = @json($pipelines);

function loadStages(pipelineId) {
    const stageSelect = document.getElementById('stage_id');
    const currentStageId = {{ $deal->stage_id }};
    stageSelect.innerHTML = '';
    
    const pipeline = pipelines.find(p => p.id == pipelineId);
    if (!pipeline || !pipeline.stages) return;
    
    pipeline.stages.forEach(stage => {
        const option = document.createElement('option');
        option.value = stage.id;
        option.textContent = stage.name;
        if (stage.id === currentStageId) {
            option.selected = true;
        }
        stageSelect.appendChild(option);
    });
}
</script>
@endsection
