@extends('layouts.app')

@section('title', $deal->title)
@section('page-title', $deal->title)

@section('content')
<div x-data="dealPage()" class="max-w-6xl mx-auto">
    <!-- Header -->
    <div class="mb-6">
        <div class="flex justify-between items-start">
            <div class="flex-1">
                <div class="flex items-center gap-3 mb-2">
                    <a href="{{ route('pipelines.show', $deal->pipeline) }}" class="text-gray-600 hover:text-gray-900">
                        <i class="fas fa-arrow-left"></i>
                    </a>
                    <h1 class="text-2xl font-bold text-gray-900">{{ $deal->title }}</h1>
                    <span class="px-3 py-1 text-sm rounded-full" style="background-color: {{ $deal->stage->color }}20; color: {{ $deal->stage->color }};">
                        {{ $deal->stage->name }}
                    </span>
                </div>
                <p class="text-gray-600 ml-10">{{ $deal->pipeline->name }}</p>
            </div>
            <div class="flex gap-2">
                <a href="{{ route('deals.edit', $deal) }}" class="px-4 py-2 border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50">
                    <i class="fas fa-edit"></i> Edit
                </a>
                <button @click="markAsWon()" class="px-4 py-2 bg-green-600 text-white rounded-lg hover:bg-green-700">
                    <i class="fas fa-check"></i> Mark Won
                </button>
                <button @click="markAsLost()" class="px-4 py-2 bg-red-600 text-white rounded-lg hover:bg-red-700">
                    <i class="fas fa-times"></i> Mark Lost
                </button>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-3 gap-6">
        <!-- Main Content -->
        <div class="col-span-2 space-y-6">
            <!-- Deal Info -->
            <div class="bg-white rounded-lg shadow p-6">
                <h2 class="text-lg font-semibold text-gray-900 mb-4">Deal Information</h2>
                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <p class="text-sm text-gray-600">Value</p>
                        <p class="text-xl font-bold text-gray-900">${{ number_format($deal->value, 2) }} {{ $deal->currency }}</p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-600">Probability</p>
                        <div class="flex items-center gap-2">
                            <div class="flex-1 bg-gray-200 rounded-full h-2">
                                <div class="bg-blue-600 h-2 rounded-full" style="width: {{ $deal->probability }}%"></div>
                            </div>
                            <span class="text-sm font-medium text-gray-900">{{ $deal->probability }}%</span>
                        </div>
                    </div>
                    <div>
                        <p class="text-sm text-gray-600">Expected Close Date</p>
                        <p class="text-sm font-medium text-gray-900">{{ $deal->expected_close_date ? $deal->expected_close_date->format('M d, Y') : 'Not set' }}</p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-600">Days in Stage</p>
                        <p class="text-sm font-medium text-gray-900">{{ $deal->days_in_stage }} days</p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-600">Contact</p>
                        <p class="text-sm font-medium text-gray-900">{{ $deal->contact->name ?? 'No contact' }}</p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-600">Owner</p>
                        <p class="text-sm font-medium text-gray-900">{{ $deal->user->name }}</p>
                    </div>
                </div>
                @if($deal->notes)
                <div class="mt-4 pt-4 border-t border-gray-200">
                    <p class="text-sm text-gray-600 mb-1">Notes</p>
                    <p class="text-sm text-gray-900">{{ $deal->notes }}</p>
                </div>
                @endif
            </div>

            <!-- Activity Timeline -->
            <div class="bg-white rounded-lg shadow p-6">
                <h2 class="text-lg font-semibold text-gray-900 mb-4">Activity Timeline</h2>
                
                <!-- Add Activity Form -->
                <form @submit.prevent="addActivity()" class="mb-6 p-4 bg-gray-50 rounded-lg">
                    <div class="flex gap-2 mb-3">
                        <button type="button" @click="activityType = 'note'" :class="activityType === 'note' ? 'bg-blue-600 text-white' : 'bg-white text-gray-700'" class="px-3 py-1 rounded text-sm border border-gray-300">
                            <i class="fas fa-sticky-note"></i> Note
                        </button>
                        <button type="button" @click="activityType = 'call'" :class="activityType === 'call' ? 'bg-blue-600 text-white' : 'bg-white text-gray-700'" class="px-3 py-1 rounded text-sm border border-gray-300">
                            <i class="fas fa-phone"></i> Call
                        </button>
                        <button type="button" @click="activityType = 'email'" :class="activityType === 'email' ? 'bg-blue-600 text-white' : 'bg-white text-gray-700'" class="px-3 py-1 rounded text-sm border border-gray-300">
                            <i class="fas fa-envelope"></i> Email
                        </button>
                        <button type="button" @click="activityType = 'meeting'" :class="activityType === 'meeting' ? 'bg-blue-600 text-white' : 'bg-white text-gray-700'" class="px-3 py-1 rounded text-sm border border-gray-300">
                            <i class="fas fa-calendar"></i> Meeting
                        </button>
                        <button type="button" @click="activityType = 'task'" :class="activityType === 'task' ? 'bg-blue-600 text-white' : 'bg-white text-gray-700'" class="px-3 py-1 rounded text-sm border border-gray-300">
                            <i class="fas fa-tasks"></i> Task
                        </button>
                    </div>
                    <textarea x-model="activityDescription" rows="2" placeholder="Add activity details..." class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 mb-2"></textarea>
                    <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 text-sm">
                        Add Activity
                    </button>
                </form>

                <!-- Activities List -->
                <div class="space-y-4">
                    @forelse($deal->activities as $activity)
                    <div class="flex gap-3">
                        <div class="flex-shrink-0">
                            <div class="w-8 h-8 rounded-full flex items-center justify-center
                                @if($activity->type === 'note') bg-blue-100 text-blue-600
                                @elseif($activity->type === 'call') bg-green-100 text-green-600
                                @elseif($activity->type === 'email') bg-purple-100 text-purple-600
                                @elseif($activity->type === 'meeting') bg-yellow-100 text-yellow-600
                                @else bg-gray-100 text-gray-600
                                @endif">
                                <i class="fas fa-{{ $activity->type === 'note' ? 'sticky-note' : ($activity->type === 'call' ? 'phone' : ($activity->type === 'email' ? 'envelope' : ($activity->type === 'meeting' ? 'calendar' : 'tasks'))) }} text-sm"></i>
                            </div>
                        </div>
                        <div class="flex-1">
                            <div class="flex items-center gap-2 mb-1">
                                <span class="font-medium text-gray-900 text-sm">{{ $activity->user->name }}</span>
                                <span class="text-xs text-gray-500">{{ $activity->created_at->diffForHumans() }}</span>
                            </div>
                            <p class="text-sm text-gray-700">{{ $activity->description }}</p>
                        </div>
                    </div>
                    @empty
                    <p class="text-center text-gray-500 py-4">No activities yet</p>
                    @endforelse
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <!-- Quick Actions -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="font-semibold text-gray-900 mb-4">Quick Actions</h3>
                <div class="space-y-2">
                    @if($deal->contact)
                    <a href="mailto:{{ $deal->contact->email }}" class="flex items-center gap-2 px-4 py-2 border border-gray-300 rounded-lg hover:bg-gray-50 text-sm">
                        <i class="fas fa-envelope text-gray-600"></i>
                        Send Email
                    </a>
                    <a href="tel:{{ $deal->contact->phone }}" class="flex items-center gap-2 px-4 py-2 border border-gray-300 rounded-lg hover:bg-gray-50 text-sm">
                        <i class="fas fa-phone text-gray-600"></i>
                        Call Contact
                    </a>
                    @endif
                    <a href="{{ route('deals.edit', $deal) }}" class="flex items-center gap-2 px-4 py-2 border border-gray-300 rounded-lg hover:bg-gray-50 text-sm">
                        <i class="fas fa-edit text-gray-600"></i>
                        Edit Deal
                    </a>
                </div>
            </div>

            <!-- Stats -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="font-semibold text-gray-900 mb-4">Statistics</h3>
                <div class="space-y-3">
                    <div>
                        <p class="text-xs text-gray-600">Weighted Value</p>
                        <p class="text-lg font-bold text-gray-900">${{ number_format($deal->weighted_value, 2) }}</p>
                    </div>
                    <div>
                        <p class="text-xs text-gray-600">Created</p>
                        <p class="text-sm text-gray-900">{{ $deal->created_at->format('M d, Y') }}</p>
                    </div>
                    <div>
                        <p class="text-xs text-gray-600">Last Updated</p>
                        <p class="text-sm text-gray-900">{{ $deal->updated_at->diffForHumans() }}</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function dealPage() {
    return {
        activityType: 'note',
        activityDescription: '',
        
        async addActivity() {
            if (!this.activityDescription.trim()) {
                alert('Please enter activity details');
                return;
            }
            
            try {
                const response = await fetch('{{ route("deals.activities.add", $deal) }}', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    body: JSON.stringify({
                        type: this.activityType,
                        description: this.activityDescription
                    })
                });
                
                const data = await response.json();
                
                if (data.success) {
                    window.location.reload();
                } else {
                    alert('Failed to add activity');
                }
            } catch (error) {
                console.error('Error:', error);
                alert('Failed to add activity');
            }
        },
        
        async markAsWon() {
            if (!confirm('Mark this deal as won?')) return;
            
            try {
                const response = await fetch('{{ route("deals.won", $deal) }}', {
                    method: 'PUT',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    }
                });
                
                const data = await response.json();
                
                if (data.success) {
                    window.location.href = '{{ route("pipelines.show", $deal->pipeline) }}';
                } else {
                    alert('Failed to mark deal as won');
                }
            } catch (error) {
                console.error('Error:', error);
                alert('Failed to mark deal as won');
            }
        },
        
        async markAsLost() {
            const reason = prompt('Reason for losing this deal (optional):');
            if (reason === null) return;
            
            try {
                const response = await fetch('{{ route("deals.lost", $deal) }}', {
                    method: 'PUT',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    body: JSON.stringify({ lost_reason: reason })
                });
                
                const data = await response.json();
                
                if (data.success) {
                    window.location.href = '{{ route("pipelines.show", $deal->pipeline) }}';
                } else {
                    alert('Failed to mark deal as lost');
                }
            } catch (error) {
                console.error('Error:', error);
                alert('Failed to mark deal as lost');
            }
        }
    }
}
</script>
@endsection
