@extends('layouts.app')

@section('title', 'Edit Email Campaign - ' . $campaign->name)
@section('page-title', 'Edit Email Campaign: ' . $campaign->name)

@section('content')
<div class="max-w-2xl mx-auto">
    <div class="bg-white rounded-lg shadow p-6">
        <form action="{{ route('email-campaigns.update', $campaign) }}" method="POST">
            @csrf
            @method('PUT')

            <div class="mb-4">
                <label for="name" class="block text-sm font-medium text-gray-700 mb-2">Campaign Name</label>
                <input type="text" name="name" id="name" value="{{ old('name', $campaign->name) }}" required
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                @error('name')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-4">
                <label for="email_template_id" class="block text-sm font-medium text-gray-700 mb-2">Email Template</label>
                <select name="email_template_id" id="email_template_id" required
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">Select Template</option>
                    @foreach($templates as $template)
                        <option value="{{ $template->id }}" {{ old('email_template_id', $campaign->email_template_id) == $template->id ? 'selected' : '' }}>
                            {{ $template->name }}
                        </option>
                    @endforeach
                </select>
                @error('email_template_id')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-4">
                <label for="subject" class="block text-sm font-medium text-gray-700 mb-2">Subject</label>
                <input type="text" name="subject" id="subject" value="{{ old('subject', $campaign->subject) }}" required
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                @error('subject')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-4">
                <label for="recipients" class="block text-sm font-medium text-gray-700 mb-2">Recipients (comma-separated emails)</label>
                @php
                    $recipientsList = is_string($campaign->recipients) ? implode(',', json_decode($campaign->recipients, true)) : implode(',', (array)$campaign->recipients);
                @endphp
                <textarea name="recipients" id="recipients" rows="3"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">{{ old('recipients', $recipientsList) }}</textarea>
                @error('recipients')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-4">
                <label for="status" class="block text-sm font-medium text-gray-700 mb-2">Status</label>
                <select name="status" id="status"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">Select Status</option>
                    <option value="DRAFT" {{ old('status', $campaign->status) === 'DRAFT' ? 'selected' : '' }}>Draft</option>
                    <option value="SCHEDULED" {{ old('status', $campaign->status) === 'SCHEDULED' ? 'selected' : '' }}>Scheduled</option>
                    <option value="SENT" {{ old('status', $campaign->status) === 'SENT' ? 'selected' : '' }}>Sent</option>
                    <option value="FAILED" {{ old('status', $campaign->status) === 'FAILED' ? 'selected' : '' }}>Failed</option>
                </select>
                @error('status')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="flex gap-4">
                <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                    Update Campaign
                </button>
                <a href="{{ route('email-campaigns.index') }}" class="px-4 py-2 bg-gray-200 text-gray-700 rounded-lg hover:bg-gray-300">
                    Cancel
                </a>
            </div>
        </form>
    </div>
</div>
@endsection
