@extends('layouts.app')

@section('title', 'Email Campaigns')
@section('page-title', 'Email Campaigns')

@section('content')
<div class="bg-white rounded-lg shadow">
    <div class="px-6 py-4 border-b border-gray-200 flex justify-between items-center">
        <h2 class="text-lg font-semibold text-gray-900">Email Campaigns</h2>
        <a href="{{ route('email-campaigns.create') }}" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
            + Create Campaign
        </a>
    </div>

    <div class="overflow-x-auto">
        <table class="w-full">
            <thead class="bg-gray-50 border-b border-gray-200">
                <tr>
                    <th class="px-6 py-3 text-left text-sm font-semibold text-gray-900">Name</th>
                    <th class="px-6 py-3 text-left text-sm font-semibold text-gray-900">Subject</th>
                    <th class="px-6 py-3 text-left text-sm font-semibold text-gray-900">Status</th>
                    <th class="px-6 py-3 text-left text-sm font-semibold text-gray-900">Created By</th>
                    <th class="px-6 py-3 text-center text-sm font-semibold text-gray-900">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($campaigns as $campaign)
                    <tr class="border-b border-gray-200 hover:bg-gray-50">
                        <td class="px-6 py-4 text-sm text-gray-900">{{ $campaign->name }}</td>
                        <td class="px-6 py-4 text-sm text-gray-600">{{ $campaign->subject }}</td>
                        <td class="px-6 py-4 text-sm">
                            <span class="px-2 py-1 rounded text-xs font-medium
                                {{ $campaign->status === 'DRAFT' ? 'bg-gray-100 text-gray-800' : '' }}
                                {{ $campaign->status === 'SCHEDULED' ? 'bg-blue-100 text-blue-800' : '' }}
                                {{ $campaign->status === 'SENT' ? 'bg-green-100 text-green-800' : '' }}
                                {{ $campaign->status === 'FAILED' ? 'bg-red-100 text-red-800' : '' }}
                            ">
                                {{ $campaign->status }}
                            </span>
                        </td>
                        <td class="px-6 py-4 text-sm text-gray-600">{{ $campaign->user->name ?? 'N/A' }}</td>
                        <td class="px-6 py-4 text-center">
                            <a href="{{ route('email-campaigns.show', $campaign) }}" class="text-blue-600 hover:text-blue-900 text-sm font-medium">View</a>
                            <a href="{{ route('email-campaigns.edit', $campaign) }}" class="text-blue-600 hover:text-blue-900 text-sm font-medium ml-3">Edit</a>
                            <form action="{{ route('email-campaigns.destroy', $campaign) }}" method="POST" class="inline" onsubmit="return confirm('Delete this campaign?')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="text-red-600 hover:text-red-900 text-sm font-medium ml-3">Delete</button>
                            </form>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="5" class="px-6 py-8 text-center text-gray-500">
                            No email campaigns found
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    @if($campaigns->hasPages())
        <div class="px-6 py-4 border-t border-gray-200">
            {{ $campaigns->links() }}
        </div>
    @endif
</div>
@endsection
