<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Team Invitation</title>
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Helvetica, Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .container {
            background: #ffffff;
            border-radius: 8px;
            padding: 40px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        .logo {
            font-size: 32px;
            font-weight: bold;
            color: #3b82f6;
            margin-bottom: 10px;
        }
        h1 {
            color: #1f2937;
            font-size: 24px;
            margin-bottom: 20px;
        }
        .invitation-box {
            background: #f3f4f6;
            border-left: 4px solid #3b82f6;
            padding: 20px;
            margin: 30px 0;
            border-radius: 4px;
        }
        .button {
            display: inline-block;
            background: #3b82f6;
            color: #ffffff !important;
            padding: 14px 32px;
            text-decoration: none;
            border-radius: 6px;
            font-weight: 600;
            margin: 20px 0;
            text-align: center;
        }
        .button:hover {
            background: #2563eb;
        }
        .info {
            background: #fef3c7;
            border-left: 4px solid #f59e0b;
            padding: 15px;
            margin: 20px 0;
            border-radius: 4px;
            font-size: 14px;
        }
        .footer {
            text-align: center;
            margin-top: 40px;
            padding-top: 20px;
            border-top: 1px solid #e5e7eb;
            color: #6b7280;
            font-size: 14px;
        }
        .link {
            color: #3b82f6;
            word-break: break-all;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div class="logo">🚀 SocialLead</div>
        </div>

        <h1>You're Invited to Join a Team!</h1>

        <p>Hi there,</p>

        <p><strong>{{ $invitation->inviter->name }}</strong> has invited you to join <strong>{{ $invitation->company->name }}</strong> on SocialLead.</p>

        <div class="invitation-box">
            <p style="margin: 0;"><strong>Company:</strong> {{ $invitation->company->name }}</p>
            <p style="margin: 10px 0 0 0;"><strong>Role:</strong> {{ ucfirst($invitation->role) }}</p>
            <p style="margin: 10px 0 0 0;"><strong>Invited by:</strong> {{ $invitation->inviter->name }} ({{ $invitation->inviter->email }})</p>
        </div>

        <p>Click the button below to accept the invitation and complete your registration:</p>

        <div style="text-align: center;">
            <a href="{{ $acceptUrl }}" class="button">Accept Invitation</a>
        </div>

        <div class="info">
            ⏰ <strong>Note:</strong> This invitation will expire on {{ $invitation->expires_at->format('F j, Y \a\t g:i A') }}.
        </div>

        <p style="font-size: 14px; color: #6b7280;">If the button doesn't work, copy and paste this link into your browser:</p>
        <p class="link" style="font-size: 12px;">{{ $acceptUrl }}</p>

        <div class="footer">
            <p>If you weren't expecting this invitation, you can safely ignore this email.</p>
            <p>&copy; {{ date('Y') }} SocialLead. All rights reserved.</p>
        </div>
    </div>
</body>
</html>
