@extends('layouts.app')

@section('title', 'Create Post')
@section('page-title', 'Create Multi-Platform Post')

@section('content')
<div class="max-w-3xl mx-auto">
    <div class="bg-white rounded-lg shadow p-6">
        <form action="{{ route('getlate.posts.store') }}" method="POST">
            @csrf

            <div class="mb-4">
                <label for="profile_id" class="block text-sm font-medium text-gray-700 mb-2">Select Profile</label>
                <select name="profile_id" id="profile_id" required
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">Choose a profile</option>
                    @foreach($profiles as $profile)
                    <option value="{{ $profile->id }}" {{ $selectedProfileId == $profile->id ? 'selected' : '' }}>
                        {{ $profile->profile_name }}
                    </option>
                    @endforeach
                </select>
                @error('profile_id')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-4">
                <label for="content" class="block text-sm font-medium text-gray-700 mb-2">Post Content</label>
                <textarea name="content" id="content" rows="6" required
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                    placeholder="Write your post content...">{{ old('content') }}</textarea>
                @error('content')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-4">
                <label class="block text-sm font-medium text-gray-700 mb-2">Select Platforms</label>
                @if(count($connectedPlatforms) > 0)
                <div class="space-y-2">
                    @foreach($connectedPlatforms as $platform)
                    <label class="flex items-center">
                        <input type="checkbox" name="platforms[]" value="{{ $platform }}" class="rounded border-gray-300 text-blue-600">
                        <span class="ml-2">{{ ucfirst($platform) }}</span>
                    </label>
                    @endforeach
                </div>
                @else
                <p class="text-gray-500 text-sm">No platforms connected. Please select a profile with connected accounts.</p>
                @endif
                @error('platforms')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-4">
                <label for="schedule_time" class="block text-sm font-medium text-gray-700 mb-2">Schedule Time (Optional)</label>
                <input type="datetime-local" name="schedule_time" id="schedule_time" value="{{ old('schedule_time') }}"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                @error('schedule_time')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="flex gap-4">
                <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                    Post Now
                </button>
                <a href="{{ route('getlate.posts.index') }}" class="px-4 py-2 bg-gray-200 text-gray-700 rounded-lg hover:bg-gray-300">
                    Cancel
                </a>
            </div>
        </form>
    </div>
</div>

<script>
    // Reload page when profile changes to fetch connected platforms
    document.getElementById('profile_id').addEventListener('change', function() {
        if (this.value) {
            window.location.href = '{{ route("getlate.posts.create") }}?profileId=' + this.value;
        }
    });
</script>
@endsection
