@extends('layouts.app')

@section('title', 'Create Profile')
@section('page-title', 'Create Profile')

@section('content')
<div class="max-w-2xl mx-auto">
    <div class="bg-white rounded-lg shadow p-6">
        @if(session('error'))
        <div class="mb-4 bg-red-50 border border-red-200 rounded-lg p-4">
            <p class="text-red-800">{{ session('error') }}</p>
        </div>
        @endif

        <form action="{{ route('getlate.profiles.store') }}" method="POST">
            @csrf

            <div class="mb-4">
                <label for="profile_name" class="block text-sm font-medium text-gray-700 mb-2">Profile Name</label>
                <input type="text" name="profile_name" id="profile_name" value="{{ old('profile_name') }}" required
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                    placeholder="e.g., My Business Profile">
                @error('profile_name')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-4">
                <label for="description" class="block text-sm font-medium text-gray-700 mb-2">Description</label>
                <textarea name="description" id="description" rows="3"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                    placeholder="Company social media">{{ old('description') }}</textarea>
                @error('description')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-4">
                <label for="color" class="block text-sm font-medium text-gray-700 mb-2">Profile Color</label>
                <div class="flex gap-3 items-center">
                    <input type="color" name="color" id="color" value="{{ old('color', '#4ade80') }}"
                        class="h-10 w-20 border border-gray-300 rounded cursor-pointer">
                    <input type="text" id="color_hex" value="{{ old('color', '#4ade80') }}" readonly
                        class="px-4 py-2 border border-gray-300 rounded-lg bg-gray-50 text-gray-700">
                </div>
                @error('color')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="flex gap-4">
                <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                    Create Profile
                </button>
                <a href="{{ route('getlate.profiles.index') }}" class="px-4 py-2 bg-gray-200 text-gray-700 rounded-lg hover:bg-gray-300">
                    Cancel
                </a>
            </div>
        </form>
    </div>
</div>

<script>
    const colorPicker = document.getElementById('color');
    const colorHex = document.getElementById('color_hex');
    
    colorPicker.addEventListener('input', function() {
        colorHex.value = this.value;
    });
</script>
@endsection
