@extends('layouts.app')

@section('title', 'GetLate Profiles')
@section('page-title', 'GetLate Profiles')

@section('content')
<div class="flex justify-between items-center mb-6">
    <h1 class="text-2xl font-bold text-gray-800">Social Media Profiles</h1>
    <a href="{{ route('getlate.profiles.create') }}" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
        <i class="fas fa-plus mr-2"></i> New Profile
    </a>
</div>

@if(session('success'))
<div class="mb-4 bg-green-50 border border-green-200 rounded-lg p-4">
    <p class="text-green-800">{{ session('success') }}</p>
</div>
@endif

<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
    @forelse($profiles as $profile)
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between mb-4">
            <h3 class="text-lg font-semibold">{{ $profile->profile_name }}</h3>
            <span class="px-2 py-1 text-xs rounded-full {{ $profile->is_active ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">
                {{ $profile->is_active ? 'Active' : 'Inactive' }}
            </span>
        </div>

        @if($profile->connected_platforms)
        <div class="mb-4">
            <p class="text-sm text-gray-600 mb-2">Connected Platforms:</p>
            <div class="flex flex-wrap gap-2">
                @foreach($profile->connected_platforms as $platform)
                <span class="px-2 py-1 bg-blue-100 text-blue-800 text-xs rounded">{{ ucfirst($platform) }}</span>
                @endforeach
            </div>
        </div>
        @endif

        <div class="flex gap-2">
            <a href="{{ route('getlate.profiles.show', $profile->id) }}" class="flex-1 px-3 py-2 bg-blue-600 text-white text-center rounded hover:bg-blue-700 text-sm">
                View
            </a>
            <form action="{{ route('getlate.profiles.destroy', $profile->id) }}" method="POST" class="flex-1">
                @csrf
                @method('DELETE')
                <button type="submit" class="w-full px-3 py-2 bg-red-600 text-white rounded hover:bg-red-700 text-sm" onclick="return confirm('Are you sure?')">
                    Delete
                </button>
            </form>
        </div>
    </div>
    @empty
    <div class="col-span-3 text-center py-8 text-gray-500">
        No profiles found. Create your first profile to start posting.
    </div>
    @endforelse
</div>
@endsection
