@extends('layouts.app')

@section('title', 'Edit Integration')
@section('page-title', 'Edit Integration')

@section('content')
<div class="max-w-2xl mx-auto">
    <div class="bg-white rounded-lg shadow p-6">
        <form action="{{ route('integrations.update', $integration->id) }}" method="POST">
            @csrf
            @method('PUT')

            <div class="mb-4">
                <label for="name" class="block text-sm font-medium text-gray-700 mb-2">Name</label>
                <input type="text" name="name" id="name" value="{{ old('name', $integration->name) }}" required
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                @error('name')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-4">
                <label for="provider" class="block text-sm font-medium text-gray-700 mb-2">Provider</label>
                <input type="text" name="provider" id="provider" value="{{ old('provider', $integration->provider) }}" required
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                @error('provider')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-4">
                <label for="description" class="block text-sm font-medium text-gray-700 mb-2">Description</label>
                <textarea name="description" id="description" rows="3" required
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">{{ old('description', $integration->description) }}</textarea>
                @error('description')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-4">
                <label for="category" class="block text-sm font-medium text-gray-700 mb-2">Category</label>
                <select name="category" id="category" required
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">Select Category</option>
                    <option value="CRM" {{ old('category', $integration->category) === 'CRM' ? 'selected' : '' }}>CRM</option>
                    <option value="Marketing" {{ old('category', $integration->category) === 'Marketing' ? 'selected' : '' }}>Marketing</option>
                    <option value="Social" {{ old('category', $integration->category) === 'Social' ? 'selected' : '' }}>Social Media</option>
                    <option value="Analytics" {{ old('category', $integration->category) === 'Analytics' ? 'selected' : '' }}>Analytics</option>
                    <option value="Communication" {{ old('category', $integration->category) === 'Communication' ? 'selected' : '' }}>Communication</option>
                </select>
                @error('category')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-4">
                <label for="logo" class="block text-sm font-medium text-gray-700 mb-2">Logo URL</label>
                <input type="text" name="logo" id="logo" value="{{ old('logo', $integration->logo) }}"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                @error('logo')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="grid grid-cols-2 gap-4 mb-4">
                <div>
                    <label for="rating" class="block text-sm font-medium text-gray-700 mb-2">Rating (0-5)</label>
                    <input type="number" name="rating" id="rating" value="{{ old('rating', $integration->rating) }}" min="0" max="5" step="0.1"
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    @error('rating')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="installs" class="block text-sm font-medium text-gray-700 mb-2">Installs</label>
                    <input type="number" name="installs" id="installs" value="{{ old('installs', $integration->installs) }}" min="0"
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    @error('installs')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            <div class="mb-4">
                <label for="pricing" class="block text-sm font-medium text-gray-700 mb-2">Pricing</label>
                <input type="text" name="pricing" id="pricing" value="{{ old('pricing', $integration->pricing) }}"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                @error('pricing')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-4">
                <label for="status" class="block text-sm font-medium text-gray-700 mb-2">Status</label>
                <select name="status" id="status" required
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="AVAILABLE" {{ old('status', $integration->status) === 'AVAILABLE' ? 'selected' : '' }}>Available</option>
                    <option value="UNAVAILABLE" {{ old('status', $integration->status) === 'UNAVAILABLE' ? 'selected' : '' }}>Unavailable</option>
                    <option value="COMING_SOON" {{ old('status', $integration->status) === 'COMING_SOON' ? 'selected' : '' }}>Coming Soon</option>
                </select>
                @error('status')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-4">
                <label class="flex items-center">
                    <input type="checkbox" name="is_installed" value="1" {{ old('is_installed', $integration->is_installed) ? 'checked' : '' }}
                        class="rounded border-gray-300 text-blue-600 shadow-sm focus:ring-blue-500">
                    <span class="ml-2 text-sm text-gray-700">Installed</span>
                </label>
                @error('is_installed')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="flex gap-4">
                <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                    Update Integration
                </button>
                <a href="{{ route('integrations.index') }}" class="px-4 py-2 bg-gray-200 text-gray-700 rounded-lg hover:bg-gray-300">
                    Cancel
                </a>
            </div>
        </form>
    </div>
</div>
@endsection
